//----------------------------------------------------------------------------//
//- CadAdministratorLogin.pas ------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zur Eingabe des Administrator-Passwortes                            //
//----------------------------------------------------------------------------//

unit CadAdministratorLogin;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, CadBoersenStart;

//------------------------------------------------------------------------------

type
  TCaDlgAdministratorLogin = class(TCaDlgBaseDialog)
    m_GrpPasswort   : TGroupBox;
    m_LblPasswort   : TLabel;
    m_EdtPasswort   : TEdit;

    //--------------------------------------------------------------------------

    procedure FormCloseQuery  (Sender: TObject; var CanClose: Boolean);
    procedure FormShow        (Sender: TObject);

  //----------------------------------------------------------------------------

  private

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------

  end; // TCaDlgAdministratorLogin

//------------------------------------------------------------------------------

var
  CaDlgAdministratorLogin: TCaDlgAdministratorLogin;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst;

//------------------------------------------------------------------------------

procedure TCaDlgAdministratorLogin.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  inherited;
  // Ist die in CadBaseDialog erfolgte Prfung, ob im Passwort-Feld ein Wert
  // eingegeben wurde, positiv ausgefallen und wurde der Dialog mit OK verlassen,
  // so wird das Passwort berprft
  if CanClose and (ModalResult = mrOk) then begin
    if not m_obCaoCheck.CheckPassword(m_EdtPasswort.Text) then begin 
      // Stimmt das Passwort nicht, wird eine Fehlermeldung angezeigt
      MessageDlg(c_sMeldungPasswortUngueltig, mtError, [mbOk], 0);
      CanClose := False;
      m_EdtPasswort.SetFocus;
    end; // else
  end // if
  else begin
    m_EdtPasswort.SetFocus;
  end; // else
end; // TCaDlgAdministratorLogin.FormCloseQuery

//------------------------------------------------------------------------------

procedure TCaDlgAdministratorLogin.FormShow(Sender: TObject);
begin
  // Zuvor gemachte Eingaben lschen
  m_EdtPasswort.Clear;
  // Den Fokus dem Passwort-Eingabefeld zuweisen
  m_EdtPasswort.SetFocus;
  inherited;
end; // TCaDlgAdministratorLogin.FormShow

//------------------------------------------------------------------------------

end. // CadAdministratorLogin
